;Version 2015-12-22
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Version=b
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so

#include <GuiConstantsEx.au3>
#include <GDIPlus.au3>

#Region GDIPlusEx
Global Const $_cGDIPEX_ISBMP = 0x41455047
Global Const $_cGDIPEX_ISBUF = 0x42455047
Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
Global $_aGDIPEX_ASMSTRUCT[1]
OnAutoItExitRegister("__GDIPlusEx_OnExit")
Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPCLONE = __GDIPlusEx_ASMCreate("0x5756538B7C24108B7424148B7614F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F858F00000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C2895424108B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C24F30F6F06F30F7F0783C61083C71083E9047FED83EB017FCD83C420B800000000EB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554889CF4889D6488B7628F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFED660F6FE0F30F7E5F10660FEACB660FEEC5660FFAC8660F6FD0660FFAD4B801000000660F6EE8660F70EDE0660F66E9660FD7C583F8000F858F00000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F44489CB4C89D74D01DA4C89E64D01EC4489C1F30F6F06F30F7F074883C6104883C71083E9047FEB83EB017FD748C7C000000000EB0748C7C0FFFFFFFF415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPTRANS = __GDIPlusEx_ASMCreate("0x578B7C2408660F6E7C240C660F70FF00B800000047660F6EF0660F70F600B8FFFFFF00660F6EE8660F70ED008B4F100FAF4F148B7F18660F6F07660F6FC8660FDBC5660F72D118660FFECE0F5CCE0F59CF0F58CE660FFACE660F72F118660FEBC1660F7F0783C71083E9107FC95FC20800", "0x660F70E900B800000047660F6EE0660F70E400B8FFFFFF00660F6ED8660F70DB008B41140FAF4118488B4920660F6F01660F6FC8660FDBC3660F72D118660FFECC0F5CCC0F59CD0F58CC660FFACC660F72F118660FEBC1660F7F014883C11083E8107FC8C3")
Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
Global Const $_pGDIPEX_ASM_WARPMXPREP = __GDIPlusEx_ASMCreate("0x8B5424048B4C2408B801000000660F6EF8F30F2AF8660F70FF00F30F2A710C660F70F600F30F2A6910660F70ED00837C24100074060F5CF70F5CEF660F7EB250010000660F7EAA540100008B4C240C0F10010F1049100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A240010000660FD69A480100000F5BE4F30F7E010F5CC4660F7E7A20660FD64224660F7E7A50660FD64254F30F7E41080F5CC40F57C90F5CC80F59CE660F7E7A68660FD6426C660FD68A80000000660F7EBA98000000660FD6829C000000F30F7E41100F5CC40F57C90F5CC80F59CD660F7EBAB0000000660FD682B4000000660F7EBAE0000000660FD682E4000000660FD68AEC000000F30F7E41180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EBAF8000000660FD682FC000000660FD68A10010000660F7EBA28010000660FD6822C010000660FD69234010000660F7EB288000000660F7EAAF4000000660F7EB218010000660F7EAA3C010000C21000", "0x4883EC20F30F7F3424F30F7F7C2410B801000000660F6EF8F30F2AF8660F70FF00F30F2A7210660F70F600F30F2A6A14660F70ED004983F90074060F5CF70F5CEF660F7EB150010000660F7EA954010000410F1000410F1048100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A140010000660FD699480100000F5BE4F3410F7E000F5CC4660F7E7920660FD64124660F7E7950660FD64154F3410F7E40080F5CC40F57C90F5CC80F59CE660F7E7968660FD6416C660FD68980000000660F7EB998000000660FD6819C000000F3410F7E40100F5CC40F57C90F5CC80F59CD660F7EB9B0000000660FD681B4000000660F7EB9E0000000660FD681E4000000660FD689EC000000F3410F7E40180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EB9F8000000660FD681FC000000660FD68910010000660F7EB928010000660FD6812C010000660FD69134010000660F7EB188000000660F7EA9F4000000660F7EB118010000660F7EA93C010000F30F6F7C2410F30F6F34244883C420C3")
Global Const $_pGDIPEX_ASM_WARPMXSLVE = __GDIPlusEx_ASMCreate("0x575653558B6C2414B800000080660F6EF883C52031C90F57C00FB6D989D889C26BD20900CA660F6E4C95000F28D70F55D10F28CA0FC2C806660FD7D1F7C20F0000007406F30F10C289C383C00183F8077ECC89DA6BD20900CA837C9500000F841D01000038CB74330FB6F989DE6BFF096BF60931C08D1406660F6E4495008D1C07660F6E4C9D00660F7E4C9500660F7E449D0083C00183F8087EDA0FB6D16BD20A8B44950083F8000F84D3000000660F6EC00FB6F16BF60988CD0FB6D501F2660F6E4C9500F30F5EC8660F7E4C950080C50180FD087EE388CD80C50180FD077F3F0FB6FD6BFF0989FA00CA660F6E4495000FB6C189FA89F301C201C3660F6E4C9500660F6E549D00F30F59D0F30F5CCA660F7E4C950083C00183F8087ED6EBB980C10180F9070F8EEAFEFFFF8B7C2414B90700000089CA6BD20983C208660F6E449500660F7E048F89CB83C30183FB077F2689CA6BD20901DA660F6E449500660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBD283E9017DB831C0EB05B8FFFFFFFF5D5B5E5FC20400", "0x5756534889CF488D7120B800000080660F6EE84831C90F57C04889CB4889D84889C2486BD2094801CA660F6E0C960F28D50F55D10F28CA0FC2C806660FD7D1F7C20F0000007407F30F10C24889C34883C0014883F8077EC74889DA486BD2094801CA833C96000F84350100004839CB74374989C84989D94D6BC0094D6BC9094831C0498D1401660F6E0496498D1C00660F6E0C9E660F7E0C96660F7E049E4883C0014883F8087EDA4889CA486BD20A8B049683F8000F84E6000000660F6EC04989CA4D6BD2094989C94C89CA4C01D2660F6E0C96F30F5EC8660F7E0C964983C1014983F9087EE24989C84983C0014983F8077F444D89C14D6BC9094C89CA4801CA660F6E04964889C84C89CA4C89D34801C24801C3660F6E0C96660F6E149EF30F59D0F30F5CCA660F7E0C964883C0014883F8087ED3EBB24883C1014883F9070F8ED0FEFFFF48C7C1070000004889CA486BD2094883C208660F6E0496660F7E048F4889CB4883C3014883FB077F284889CA486BD2094801DA660F6E0496660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBCE4883E9017DB031C0EB05B8FFFFFFFF5B5E5FC3")
Global Const $_pGDIPEX_ASM_WARPVAL = __GDIPlusEx_ASMCreate("0x57568B7C240C8B742410B907000000660F6E048E660F70C00089CAC1E2040F29041783E9017DE8B801000000F30F2AC0660F70C0000F298780000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298790000000660F6E8650010000660F6E8E54010000660F70C000660F70C9000F2987A00000000F298FB00000008B44241489874C010000C1E802F30F2AC0660F70C0000F2987C0000000B800000047660F6EC0660F70C000660F7F8730010000F30F7E8648010000660FD687400100008B4424188987480100005E5FC21000", "0x49C7C20700000066420F6E0492660F70C0004D89D349C1E304420F2904194983EA017DE3B801000000F30F2AC0660F70C0000F298180000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298190000000660F6E8250010000660F6E8A54010000660F70C000660F70C9000F2981A00000000F2989B00000004489814C01000041C1E802F3410F2AC0660F70C0000F2981C0000000B800000047660F6EC0660F70C000660F7F8130010000F30F7E8248010000660FD6814001000044898948010000C3")
Global Const $_pGDIPEX_ASM_WARP = __GDIPlusEx_ASMCreate("0x575653558B6C24148BBD500100008BB5540100008B8D4001000083E904660F6EF9660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000008B9D44010000660F6EE3660F70E4000F5BE40F5CA58000000083EB010F2845700F288D800000000F59C40F58C70F5EC80F285D200F2855500F59DC0F59D40F58DE0F58D50F59D90F59D10F2885A00000000F288DB00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F8495000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5995C00000000F58DAF30F5BDB660F72F302660FEFC0A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC189DA0FAF95480100008D148AF30F7F041783FB000F8FF1FEFFFF83F9000F8F9FFEFFFF5D5B5E5FC20400", "0x57564883EC20F30F7F3424F30F7F7C2410488BB950010000488BB158010000448B81400100004183E80466410F6EF8660F70FF000F5BFF0F58B9900000000F2871100F2869400F59F70F59EF0F58310F5869300F5979600F58B980000000448B894401000066410F6EE1660F70E4000F5BE40F5CA1800000004183E9010F2841700F2889800000000F59C40F58C70F5EC80F2859200F2851500F59DC0F59D40F58DE0F58D50F59D90F59D10F2881A00000000F2889B00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F849B000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5991C00000000F58DAF30F5BDB660F72F302660FEFC04831D2A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC14489CA0FAF914801000067428D1482F30F7F04174183F9000F8FE9FEFFFF4183F8000F8F93FEFFFFF30F6F7C2410F30F6F34244883C4205E5FC3")
Global Const $_pGDIPEX_ASM_WARPIP = __GDIPlusEx_ASMCreate("0x575653558B6C241483EC048BBD500100008BB5540100008B8D40010000890C24832C2404660F6E3C24660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000000F29BDD00000000F29B5E00000000F29ADF00000008B9D4401000083EB01F30F2AFB660F70FF000F2845700F288D800000000F59C70F5885D00000000F5EC80F2875200F286D500F59F70F59EF0F58B5E00000000F58ADF00000000F59F10F59E90F2885A00000000F288DB00000000FC2C6020FC2CD020F56C10F57C90F57D20FC2CE050FC2D5050F56C10F56C20F50C083F80F0F8434010000F30F5BFEF30F5BC50F5BFF0F5BC00F5CF70F5CE80F5985C00000000F58F8F30F5BFF660F72F7020F29AD200100000F29B5100100000F29BD000100000F288D30010000660FEFC0B903000000660F73F804A9080000000F85B90000008B948D00010000F30F7E3C1603954C010000F30F7E3416660FEFD2660F60FA660F60F2660F6FEF660F6FE6660F60FA660F60F2660F68EA660F68E2660FFEF9660FFEF1660FFEE9660FFEE10F5CF90F5CF10F5CE90F5CE1660F6E9C8D100100000F289580000000660F70DB000F5CD30F59FA0F59F20F59EB0F59E30F58FD0F58F4660F6E9C8D200100000F289580000000660F70DB000F5CD30F59FA0F59F30F58FE0F58F9660FFAF9660FEFD2660F6BFA660F67FAF30F10C7D1E083E9010F8D2CFFFFFF89DA0FAF95480100008B0C248D148AF30F7F041783FB000F8F44FEFFFF833C24000F8FE6FDFFFF83C4045D5B5E5FC20400", "0x57564881ECA0000000F30F7F3424F30F7F7C2410F3440F7F442420F3440F7F4C2430F3440F7F542440F3440F7F5C2450F3440F7F642460F3440F7F6C2470F3440F7FB42480000000F3440F7FBC2490000000488BB950010000488BB158010000440F28A180000000448B81400100004831D24183E80466450F6EF866450F70FF00450F5BFF440F58B990000000440F287110440F286940450F59F7450F59EF440F5831440F586930440F597960450F58FC448B89440100004183E901F3410F2AF9660F70FF000F284170410F28CC0F59C7410F58C70F5EC8440F285120440F284950440F59D7440F59CF450F58D6450F58CD440F59D1440F59C90F2881A00000000F2889B0000000410FC2C202410FC2C9020F56C10F57C90F57D2410FC2CA05410FC2D1050F56C10F56C20F50C083F80F0F8424010000F3450F5BDAF3410F5BC1450F5BDB0F5BC0450F5CD3440F5CC80F5981C0000000440F58D8F3450F5BDB66410F72F3020F288930010000660FEFD2660FEFC041BA03000000660F73F80466450F70DB93A9080000000F859E00000066440F7EDAF30F7E1C1603914C010000F30F7E2416660F60DA660F60E2660F6FEB660F6FF4660F60DA660F60E2660F68EA660F68F2660FFED9660FFEE1660FFEE9660FFEF10F5CD90F5CE10F5CE90F5CF166450F70C2FF410F28FC410F5CF80F59DF0F59E7410F59E8410F59F00F58DD0F58E666450F70C1FF410F28FC410F5CF80F59DF410F59E00F58DC0F58D9660FFAD9660F6BDA660F67DAF30F10C366410F73FA0466410F73F904D1E04183EA010F8D34FFFFFF4489CA0FAF914801000067428D1482F30F7F04174183F9000F8F53FEFFFF4183F8000F8F03FEFFFFF3440F6FBC2490000000F3440F6FB42480000000F3440F6F6C2470F3440F6F642460F3440F6F5C2450F3440F6F542440F3440F6F4C2430F3440F6F442420F30F6F7C2410F30F6F34244881C4A00000005E5FC3")
Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
		"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
Global Const $_pGDIPEX_ASM_FXGREY = __GDIPlusEx_ASMCreate("0x8B5424040F107C24048B4A100FAF4A148B5218660F73DF04B8FF000000F30F2AF0660F70F6000F59FEF30F5BFF660F6BFF660FEFF6660F6F02660F6FC8660F6FE0660F60C6660F68CE660F72D418660FF5C7660FF5CF660F72F418660F70D0B1660F70D9B1660FFEC2660FFECB660F72D008660F72D108660F6BC1660F70C8FA660F70C050660F67C1660F72F008660F72D008660FEBC4660F7F0283C21083E9107F92C21000", "0x4883EC10F30F7F34248B51140FAF5118488B4920660F6FE9660F73FA04660F73FB08660FEBEA660FEBEBB8FF000000F30F2AF0660F70F6000F59EEF30F5BED660F6BED660FEFF6660F6F01660F6FC8660F6FE0660F60C6660F68CE660F72D418660FF5C5660FF5CD660F72F418660F70D0B1660F70D9B1660FFEC2660FFECB660F72D008660F72D108660F6BC1660F70C8FA660F70C050660F67C1660F72F008660F72D008660FEBC4660F7F014883C11083EA107F91F30F6F34244883C410C3")
#EndRegion


_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $bExit
Global Const $fPI = ACos(-1), $fRad = $fPI / 180, $fPI8 = $fPI / 8, $sTitle = "GDI+ Wave v1.3.1 / FPS: "
AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_Wave()

AutoItSetOption("GUIOnEventMode", 0)
_GDIPlus_Shutdown()
ConsoleWrite("The end." & @CRLF)

Func GDIPlus_Wave()
	$bExit = False
	Local Const $iW = 600, $iH = 650
	$hGUI = GUICreate($sTitle & 0, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)

	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
	Local Const $hBrush = _GDIPlus_BrushCreateSolid(0xFFFFFFFF), $hPen = _GDIPlus_PenCreate(0xF0080808, 4)

	Local Const $iDots_X = 13, $iDots_Y = 13, $iDots_Diameter = 36, $iDots_Distance = $iDots_Diameter * 1, $fRadius = $iDots_Distance / 2, $iDots_Radius = $iDots_Diameter / 2
	Local Const $iW_Bmp = ($iDots_Diameter + ($iDots_X - 1) * $iDots_Distance), $iH_Bmp = ($iDots_Diameter + ($iDots_Y - 1) * $iDots_Distance)
	Local $iX, $iY, $aCoords[$iDots_Y][$iDots_X][3], _
		  $iPos_X = ($iW - $iW_Bmp) / 2, _
		  $iPos_Y = ($iH - $iH_Bmp) / 2

	Local Const $hBitmap = _GDIPlus_BitmapCreateFromMemory(_Pirate()), $iW_Bmp_Flag = _GDIPlus_ImageGetWidth($hBitmap), $iH_Bmp_Flag = _GDIPlus_ImageGetHeight($hBitmap)
	Local $hImg = _GDIPlus_BitmapCreateFromScan0($iW_Bmp / $iDots_X, $iH_Bmp / $iDots_Y), $hCtx = _GDIPlus_ImageGetGraphicsContext($hImg)
	For $iY = 0 To UBound($aCoords) - 1
		For $iX = 0 To UBound($aCoords, 2) - 1
			_GDIPlus_GraphicsClear($hCtx, 0)
			_GDIPlus_GraphicsDrawImageRectRect($hCtx, $hBitmap, $iX * $iW_Bmp_Flag / ($iDots_X - 1), _
																$iY * $iH_Bmp_Flag / ($iDots_Y - 1), _
																$iW_Bmp_Flag / ($iDots_X - 1), _
																$iH_Bmp_Flag / ($iDots_Y - 1), _
																0, 0, $iW_Bmp / $iDots_X, $iH_Bmp / $iDots_Y)
			$aCoords[$iY][$iX][2] = _GDIPlusEx_BitmapCreateFromImage($hImg)
		Next
	Next
	_GDIPlus_GraphicsDispose($hCtx)
	_GDIPlus_ImageDispose($hImg)
	_GDIPlus_ImageDispose($hBitmap)

	Local Const $hPath_X = _GDIPlus_PathCreate(), $hPath_Y = _GDIPlus_PathCreate(), $hPath = _GDIPlus_PathCreate()

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	Local $fSpeed = -2^32 + 1, $fFrequenz = 3.25, $aPointsX, $aPointsY, $t

	ConsoleWrite(($iW - $iW_Bmp) / 2 & @CRLF)
	AdlibRegister("CalcFPS", 1000)

	Do
		_GDIPlus_GraphicsClear($oBuffer.Gfx, 0xFF606060)

		For $iY = 0 To UBound($aCoords) - 1
			For $iX = 0 To UBound($aCoords, 2) - 1
				$t = ($fSpeed + $iX + $iY) / $fFrequenz
				$aCoords[$iY][$iX][0] = $iDots_Radius + $iX * $iDots_Distance + ATan(-$fSpeed + $iX) * Cos(-$t + $fSpeed) * $fRadius
				$aCoords[$iY][$iX][1] = $iDots_Radius + $iY * $iDots_Distance + ATan($fSpeed * 2) * Sin($t * ATan($t * $fSpeed)) * $fRadius
			Next
		Next

		$aCoords[0][0][0] = $aCoords[0][0][0] > -10 ? -10 : $aCoords[0][0][0]
		$aCoords[1][0][0] = $aCoords[1][0][0] > 16 ? 16 : $aCoords[1][0][0]
		$aCoords[$iDots_Y - 2][0][0] = $aCoords[$iDots_Y - 2][0][0] > 16 ? 16 : $aCoords[$iDots_Y - 2][0][0]
		$aCoords[$iDots_Y - 1][0][0] = $aCoords[$iDots_Y - 1][0][0] > -10 ? -10 : $aCoords[$iDots_Y - 1][0][0]

		DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $oBuffer.Gfx, "handle", $hPen, "float", 0, "float", 100, _
							   "float", $iPos_X + $aCoords[0][0][0] + 2, "float", $iPos_Y + $aCoords[0][0][1] + 2)

		DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $oBuffer.Gfx, "handle", $hPen, "float", 0, "float", 500, _
							   "float", $iPos_X + $aCoords[$iDots_Y - 1][0][0] + 2, "float", $iPos_Y + $aCoords[$iDots_Y - 1][0][1] - 2)

		For $iY = 0 To UBound($aCoords) - 2
			For $iX = 0 To UBound($aCoords, 2) - 2
				_GDIPlusEx_BitmapWarp($oBuffer, $aCoords[$iY][$iX][2], _
									$iPos_X + $aCoords[$iY][$iX][0], $iPos_Y + $aCoords[$iY][$iX][1], _
									$iPos_X + $aCoords[$iY][$iX + 1][0] + 0.5, $iPos_Y + $aCoords[$iY][$iX + 1][1], _
									$iPos_X + $aCoords[$iY + 1][$iX][0], $iPos_Y + $aCoords[$iY + 1][$iX][1] + 0.5, _
									$iPos_X + $aCoords[$iY + 1][$iX + 1][0] + 0.5, $iPos_Y + $aCoords[$iY + 1][$iX + 1][1] + 0.5)
			Next
		Next
		$fSpeed += 0.45
		_GDIPlus_GraphicsDrawString($oBuffer.Gfx, "Coded by UEZ / Eukalyptus", 2, $iH - 12, "Arial", 7.5)
		_GDIPlusEx_BufferDraw($oBuffer)
		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	_GDIPlus_PathDispose($hPath_X)
	_GDIPlus_PathDispose($hPath_Y)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_BrushDispose($hBrush)
	$oBuffer = Null
	For $iY = 0 To UBound($aCoords) - 1
		For $iX = 0 To UBound($aCoords, 2) - 1
			$aCoords[$iY][$iX][2] = Null
		Next
	Next
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Wave

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc   ;==>CalcFPS

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _Pirate($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Pirate
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= 'OvkXyFZys7lmcs5XyFZysyngBhXREaSJR1BHS0QHGdIX8ndvo5V6ijRtes0KN+aeEHURm0gbTphOM8AsRB9G1GrRK6jUlZke7vUUcJFAETJ0DZTW2oFG/ob0mEEaRApKnvQSFMqZFAgniCBKOmET66+hglw3cXKaTomsdudAQThLSVOiFOgmfWXqyzUaxSaR3Pg20N1D2o6bUAU0jvBaZadDU2/uRsFb0DRKan9VQm3PV7gckqe1Yi2S4aAsMyjfST7PxQDTPdNRhZkb1acrjf3Him/pQrp1/cwpU1is90FnnSD7oWrChQoUUjuAhMTpHum02UqVPBHahCY86PHuRogqO+Kk6fHuRcrdbrfvhcwiNJt7oCWqSp74CV5N6hPt7rCO5ozdzsMRkXxr418S+FfCvhXxhZAsoWUIMC+IL4wiwLKFAUIjibbyRBq0J+x927emEEbNCjUaQVBpmWdE8wo69QYR+3vGbtWEdzYVlSppmCKzLOi5TWFlRYiNEayNv6oAiIATh7thh3nD6joJWZZisxUrMp0TQFZ1nU6IUKFFWiXYiPUaN6sSws6x90L+cNFAULmrO1OcxSFIQKjhARaAiWrMFnQcFLF9VCNAYTn5kE6g6ndLbI+7Kw+lOxQEcQlTrmkqVK2pMIvU65WYrNUFE0uXSm0db3X9BYpIPE1EJrcy+NFsdharbvsgnW9y246wse/EFlTAnbCZpG3L/KC8+E1O903qBk2OP1cEIDcBFNWJ0hWQR42CV5/inkMzUb7tvUEN1jiW6gKNbKa1DqKasUmBZC54gEPqxfzRkZp2Q2QTr+4beh+zSINYUIBZUAjvQoJ/SK34WtlBixCgmiSWQnCBSKQi1R7lu6KBhPbKLaAINq1XUiS5DdOxQg8FquipU6oTWINTjAKCwgsS+JdePDUCpUJ3uMEyiEQp2iQWLIgwrKak0hYp0NMHRK2UBQEA1SAjihOcXUG6H1bcvugYRfS4QKdb27XZSDIKurLOF8gWdHETXAnYLZbIGBwTtTbXhBPdJRuAoUUYU4Ly73OC+Cd1CN6woIWfZNEjE2bweOBqmjzQJwgGo3bKf7lqZiLEfCneayiSTH0WHs3EvUiKu4wYEolO6kE6xq2xQMoj3DQiv5hQor5CZad3XNMIS596Ef8APjzJtzdChqDt7oHYob4dQaeWLynDY0w25WG6w8PZ5AHINqgqUa+PdBFYSeyDVqEL+CvH85d2sAQ3T7+cyc6ToGxOx0gI9NMMItRHvgimKMwNAimjc7N/lqC8ygnH7aQrrfM6+iJQCd00wyiU4++iERuNkFijerOh68CnleNAE6M31a1sEQaBN6U7ooER77DuV4PWw7Ym7a4X+dzCAUUhBFqy1CcE2lzbQEdgE7o4D7nD6vBNBtRwg0Y6GtoEEamhUfWlgPsT9TjD71aE+4Th/wA6C5b9PeASrLMvKYUE5stph3dsc6FvDzCC8xJ8uTN2+d00iB/nMl7sxrZpu2+Jajbu6D7sCoXgpvU/bEZd7crlh9TP9CE6Wr5CC54cmguadi1ycwwEcFEfewOzidIEpx+/lieftRrSU4OCjVHtI02aNxh9eIN2XxW5gWkUYftP2xT9H9Sw+jHCwOrFP1asT/KzplP6tEIbLymWcatXlw+2q/sQJVtXhqdsQ7MxlynOREUF3GUbof5EyMLZPOZC7z9EDFWtlEEIVFLMJmoTet3VwR64NR0W0eH3w7sd9jZygZNObaVKngccx0RsTJqHLNHtwANMxoFPI2IaHKSE5bTc8w0tEnEO+k7e1jhmjAnI0Y6FKIRplcVkblbhucCxw4AEUNkTNYlGFMDV41X9bGgisaWXPUatNIRygiGl7HFH6tLvq1rY2C2nOUZNRKIgnUTrjgBUUn08cFtNkL3R0NMhzspxIch9luVMD6oORKF6QoXiZBQFQETPA1wRvwba49ABwE6Zo2ynQDBBDhsrULpHEFmpdOdPDtBv2F+9jXGmFZHegR2G'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= 'MMNMMBNKFBDMBFFMBHHEINPGJCHFPHFGHKIACGPFNLJILAMEJMNHEADLHNLGCKCBCHMODGBPPLNMHFMJIJPLGJNMDJLMLNDKJFMKEPJCFIAEJKCHPEFEIHKAHELCNLJFACBHPPOEPLFCNHNGIENOBDIEKDJADOCAEDJPDDPIMHLEJFPIHOALPHPPLFFGLMzEKPBCHAPOMPDPGMOPDAEIHOKBBDHGGGIOIDPOAPGLOPPODIJNKNIBMDHOBNLMKEJPNMNDCLPMOBKGPMBMHICGBHMGPCJPNHJOJM8FADAFFPPGH+99xHDJNCGEIDIPCHCBHOIFPDFLDCFECIKFCDEMBPGPOMOD4z7q9z8ktjGDDMIPJLOLKNNKCAPADPPLANCKAOMCLMCEDAAADo+k8/y2gOIEMFNDCMAFnqGGOIPOMAPLAPANLFMJPDBPPJDPL79DWv70XGTwOHCKlsEGGJvDHOKKHCAHPIANBAMPIEPPPFDIOj3Jp+8pTYE34go+yggjsKAHJHNPGMAHIPPAAPKAAPEANPPGKIBO5yxk6ysFN/gQQQQ49JLCAEJBPPPAGIONMDAPMAEPJAAPPPCKku2v+81owaJvygQQV7vwuDEANPPIEFAABPLDAPPMIPPLAEPPPDlWjsg31JMKNtogQVb2Omu7MFPLAAFGDAHPIDAMEIANPLIHNPPLEHfIhsaLLD5/ogTQfHjAhhBPKPOMMBIBHLFGMAAAAPPPAMEPPOpBFORI3fXEam+gUfbOudVrPOHPCPGNIMPFKBMAABHPPPDAAMPLTdVQJdLaSWQ9/wCIGE3GqbbzyBTyDyxjzwBShzwTyThTTzwwABzwtbttN40WoqLcqkFDdzHf7zgByBCxyjzwTxDgAAQwixTzzgAADSgqAuBz8MPceJZw6bM46QLwBSgDzzyyzyzgADwBTwDzzzywAABTygjSxDQlVmLpih8+MaQgOgjyADjTzyyywDAjAyAAQDDzzwAADSwiAxzzzzyJCzzzwziaNzmMzyQwBTzzygACADzzDyzTTzTgABhTwBDzzCio4gYjzzzhizyAotQAxyBTzzCAQwAgDxTyzxzzwAAABzgvhAQgM8NhccjjyAwbiOXSQhBAxiBQATzzzzyzxzgATjygAABDwt9yRNedwywjBARpIZBvmPCAzDzwAABBzzzzzzzzyxxywgAAADwxBYjpnvTxyAASAzQ+gNQWjBTzAAABShzzzzzzzzzyzzyxAAADSi/ThbQtRyywyTxySTDnaQNyCAAAABDTzzzzzzzzzzjzzzwQwgDF9yjbOJQQCTijTzwQR2vpVQgAAAACzzzzzzzzzzzzzxTzzzyATx/GxCOmFCyyTrDyTYHbfvxAwgAAAAADzzwDDzzzzzzzzzzzygQqefThMduejTiiTwY8Gwtj2jTyxwgwhTzzzwzjBzzzyzzzywAAghz5z5G/s7zuExzxK8p2cpGgBzzzzzxzzzywzyATjzjzzjygTySqiKMBvByBCCvzQRZ4+Uv/AJEMgUUc8880040A0oo08Y04wgMI8wUMTnUY8sMsM8ksACRrAJC4MsMIQc88888cM84AAgwAAAEAEAA4cQj4Tzzyz48ssaurRD5MOEEUYQcU888AQ8o8oAAAAAckwgAMAccsosdm86L4wAcutHqW1Wqc88kkmoQw4AAAMwAAAMMc4cAOacscQgYwgFDuoAI4UEgeau7fT8sQ4AU8MIgAQAAAAAU84MQKSgIsc8MHoAIUGjnaEEMwAYmWufe888Y0gKCAskIAAAAIcEU0QUwM88888DE40sIogwQwAwYgSDzAqww88ccogAkcwMAAUMk8wEoMc8888wwgYAAoM4I4Ew8IAEBOLAtAQQ8888scUoMkgAQA48888888wwAMM8AEIQgwo4MEIQ0gCnxQpAAAc88888s8M8YAAAAQAQ8884AAA8csQwMEAYgEowUAEYdvfw0848E08848wgQQAAEIAEAAQwwAAMs88wgM'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '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'
	$Pirate &= '01H6C4h9HmPU1/jf/9k='
	Local $bString = _WinAPI_Base64Decode($Pirate)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Pirate_788x788.jpg", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Pirate

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight, $iColor)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate

Func _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $iImgW = _GDIPlus_ImageGetWidth($hImage)
	Local $iImgH = _GDIPlus_ImageGetHeight($hImage)
	If @error Or Not $iImgW Or Not $iImgH Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If $iWidth = 0 Then $iWidth = $iImgW
	If $iHeight = 0 Then $iHeight = $iImgH
	Local $oBitmap = _GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	If @error Then Return SetError(@error, @extended, False)
	Local $iIP = _GDIPlus_GraphicsGetInterpolationMode($oBitmap.Gfx)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iInterpolationMode)
	_GDIPlus_GraphicsDrawImageRectRect($oBitmap.Gfx, $hImage, 0, 0, $iImgW, $iImgH, 0, 0, $iWidth, $iHeight, $hImgAttr)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iIP)
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromImage

Func _GDIPlusEx_BitmapWarp($oBuffer, $oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol = False)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iX, $iY
	Local $tWarp = __GDIPlusEx_BitmapWarpCreateBitmap($oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol, $iX, $iY)
	If @error Or Not IsDllStruct($tWarp) Then Return SetError($GDIP_ERRABORTED, 2, $tWarp)
	DllCallAddress("int", $_pGDIPEX_ASM_BMPDRAW, "struct*", $tWarp, "struct*", __GDIPlusEx_ObjGetPtr($oBuffer), "int", $iX, "int", $iY)
	__GDIPlusEx_BitmapDispose($tWarp)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapWarp

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_BitmapWarpCreateBitmap($oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol, ByRef $iX, ByRef $iY)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tMatrix = DllStructCreate("float WF[8]; float Tmp[72]; int DstX; int DstY; uint DstW; uint DstH; float SrcW; float SrcH;")
	Local $tWarpPnts = DllStructCreate("float[8];")
	DllStructSetData($tWarpPnts, 1, $fX1, 1)
	DllStructSetData($tWarpPnts, 1, $fY1, 2)
	DllStructSetData($tWarpPnts, 1, $fX2, 3)
	DllStructSetData($tWarpPnts, 1, $fY2, 4)
	DllStructSetData($tWarpPnts, 1, $fX3, 5)
	DllStructSetData($tWarpPnts, 1, $fY3, 6)
	DllStructSetData($tWarpPnts, 1, $fX4, 7)
	DllStructSetData($tWarpPnts, 1, $fY4, 8)
	DllCallAddress("none", $_pGDIPEX_ASM_WARPMXPREP, "struct*", $tMatrix, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "struct*", $tWarpPnts, "bool", $bInterpol)
	Local $iDstW = DllStructGetData($tMatrix, "DstW")
	Local $iDstH = DllStructGetData($tMatrix, "DstH")
	If $iDstW < 1 Or $iDstH < 1 Then Return SetError($GDIP_ERRABORTED, 2, False)
	If Mod($iDstW, 4) Then
		$iDstW += 4 - Mod($iDstW, 4)
		DllStructSetData($tMatrix, "DstW", $iDstW)
	EndIf
	Local $aResult = DllCallAddress("int", $_pGDIPEX_ASM_WARPMXSLVE, "struct*", $tMatrix)
	If @error Or $aResult[0] <> 0 Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $tWarp = __GDIPlusEx_BitmapCreate($iDstW, $iDstH)
	$iX = DllStructGetData($tMatrix, "DstX")
	$iY = DllStructGetData($tMatrix, "DstY")
	Local $tVal = DllStructCreate("byte Val[356]; byte Pad[16];")
	Local $pVal = Number(DllStructGetPtr($tVal))
	$pVal += 16 - Mod($pVal, 16)
	Local $tValues = DllStructCreate("float WF1[4]; float WF2[4]; float WF3[4]; float WF4[4]; float WF5[4]; float WF6[4]; float WF7[4]; float WF8[4]; float One[4]; float XOff[4]; float SrcW[4]; float SrcH[4]; float SrcS[4]; float TmpX[4]; float TmpX1[4]; float TmpX2[4]; float Idx[4]; float fX[4]; float fY[4]; uint Msk[4]; uint DstW; uint DstH; uint DstStride; uint SrcStride; ptr Dst; ptr Src;", $pVal)
	DllCallAddress("none", $_pGDIPEX_ASM_WARPVAL, "struct*", $pVal, "struct*", $tMatrix, "uint", $oBitmap.Stride, "uint", $iDstW * 4)
	DllStructSetData($tValues, "Dst", DllStructGetData($tWarp, "pScan0"))
	DllStructSetData($tValues, "Src", $oBitmap.Scan0)
	Switch $bInterpol
		Case True
			DllCallAddress("none", $_pGDIPEX_ASM_WARPIP, "struct*", $pVal)
		Case Else
			DllCallAddress("none", $_pGDIPEX_ASM_WARP, "struct*", $pVal)
	EndSwitch
	Return $tWarp
EndFunc   ;==>__GDIPlusEx_BitmapWarpCreateBitmap

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit